setwd("<your directory or folder path>")
df1 <- read.csv("20191125 Example 9.2 Zero-Inflated Poisson.csv")
#
#
#  need to execute library(pscl) once during R session
library(pscl)
#
# VARIABLES:
# Index
# X1
# X2
# Response
#
attach(df1)
linreg <- lm(Response ~ X1 + X2)
regpoisson <- glm(Response ~ X1 + X2,data=df1,family=poisson("log"))
overpoisson <- glm(Response ~ X1 + X2,data=df1,family=quasipoisson("log"))
#zeropoisson <- zeroinfl(Carry ~ Length + Age,control=zeroinfl.control(start=list(count=c(-2,0.9,0.1),zero=c(-2,-0.2,-0.05))),data=df1,dist="poisson",link="log")
zeropoisson <- zeroinfl(Response ~ X1 + X2,EM=TRUE,data=df1,dist="poisson",link="log")
plot(X1,zeropoisson$fitted.values,pch=1,ylim=c(0,18),main="Poisson Models: Predicted vs. X1",ylab="Response (counts)")
points(X1,regpoisson$fitted.values,pch=2)
points(X1,overpoisson$fitted.values,pch=3)
points(X1, linreg$fitted.values,pch=4)
points(X1,Response,pch=5)
legend(x=26,y=6,legend=c("Zero-Inflated Poisson","Regular Poisson","Overdispersed Poisson","OLS Reg","Observed"),pch=c(1,2,3,4,5))
summary(linreg)
summary(regpoisson)
summary(overpoisson)
summary(zeropoisson)
